'==========================================================================
'
' Author......: Raffaele Chiatto
'
' WebSite.....: http://www.raffaelechiatto.com
'
' E-Mail......: raffaele.chiatto@gmail.com
'
'==========================================================================

Option Explicit

' Flags for the options parameter
Const BIF_returnonlyfsdirs   = &H0001
Const BIF_dontgobelowdomain  = &H0002
Const BIF_statustext         = &H0004
Const BIF_returnfsancestors  = &H0008
Const BIF_editbox            = &H0010
Const BIF_validate           = &H0020
Const BIF_browseforcomputer  = &H1000
Const BIF_browseforprinter   = &H2000
Const BIF_browseincludefiles = &H4000

Dim file

file = BrowseForFolder( _
        "Select a file or folder to copy", _
        BIF_returnonlyfsdirs + BIF_browseincludefiles, _
        "")
If file = "-5" Then 
    WScript.Echo "Not possible to select files in root folder"
Else
    If file = "-1" Then 
        WScript.Echo "No object selected; Cancel clicked"
    Else
        WScript.Echo "Object: ", file
    End If
End If 

' Using the shell's BrowseForFolder method to
' return the full path to the selected object
' title = Text shown in the dialog box
' flag = One of the values for controlling the 
'        BrowseForFolder behavior
' dir = Preselected directory (can be "")
Function BrowseForFolder(title, flag, dir)
    On Error Resume Next

    Dim oShell, oItem, tmp
 
    ' Create WshShell object.
    Set oShell = WScript.CreateObject("Shell.Application")

    ' Invoke Browse For Folder dialog box.
    Set oItem = oShell.BrowseForFolder(&H0, title, flag, dir)
    If Err.Number <> 0 Then
        If Err.Number = 5 Then
            BrowseForFolder= "-5"
            Err.Clear
            Set oShell = Nothing
            Set oItem = Nothing
            Exit Function
        End If
    End If

    ' Now we try to retrieve the full path.
    BrowseForFolder = oItem.ParentFolder.ParseName(oItem.Title).Path

    ' Handling: Cancel button and selecting a drive
    If Err<> 0 Then
        If Err.Number = 424 Then           ' Handle Cancel button.
            BrowseForFolder = "-1"
        Else
            Err.Clear
            ' Handle situation in which user selects a drive.
            ' Extract drive letter from the title--first search
            ' for a colon (:).
            tmp = InStr(1, oItem.Title, ":")
            If tmp > 0 Then           ' A : is found; use two 
                                      ' characters and add \.
                BrowseForFolder = _   
                    Mid(oItem.Title, (tmp - 1), 2) & "\"
            End If
        End If
    End If

    Set oShell = Nothing
    Set oItem = Nothing
    On Error GoTo 0
End Function

'*** End